/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Id: PNM_PNIOAPCFG_Functionlist.h 18776 2011-08-17 07:01:48Z Benjamin $
   Last Modification:
    $LastChangedBy: Benjamin $
    $LastChangedDate: 2011-08-17 09:01:48 +0200 (Mi, 17 Aug 2011) $
    $LastChangedRevision: 18776 $
   
   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes
 
   Description:
     
    PNIO APCFG
    Task function list for configuration file
       
   Changes:
 
    Date        Author       Description
    ----------- ------------ ---------------------------------------------------------
    2011-03-14  B. Meyer     fixed mantis #12783 - added support for Taglist with Profinet IDs
                                extended startup parameters and changed parameter version

        
**************************************************************************************/
/**
 * @file PNIOAPCFG_Functionlist.h
 * @brief PNIO APCFG - function list
 *
 * The header has to be included in the configuration source file of firmware.
 * Use the content of header file to configure the startup parameter of tasks
 * and to define the entry point <code>TaskEnter_PNM_PNIOAPCFG</code>
 * of task.
 */
#ifndef __PNIO_APCFG_FUNCTIONLIST_H
#define __PNIO_APCFG_FUNCTIONLIST_H


/*************************************************************************************/
/** @name Prototypes
 *
 * The following prototypes are declared to represent
 * - the entry point of task
 * - the exit point of task to delete only the task resources (exit)
 * - the exit point of task to force a friendly shutdown (leave)
 * @{
 */

TLR_RESULT TaskExit_PNM_PNIOAPCFG (TLR_VOID FAR* pvRsc);
TLR_RESULT TaskEnter_PNM_PNIOAPCFG(TLR_VOID FAR* pvInit);


/** @} */


#define PNIO_APCFG_TASK_FLAG_EVALUATE_PN_IDENT_TAGLIST    (1)

/*************************************************************************************/
/** @name Task Version
 *
 * Subsequently the version of task is defined.
 */

/** version of task startup parameter */
#define PNIO_APCFG_STARTUP_PARAM_VERSION_3 (3)


/*************************************************************************************/
/** @name Startup Parameter
 *
 * The following definition represent the task startup parameter.
 * @{
 */

/** task startup parameter */
typedef struct PNIO_APCFG_STARTUPPARAMETER_Ttag  PNIO_APCFG_STARTUPPARAMETER_T;


/** task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */
struct PNIO_APCFG_STARTUPPARAMETER_Ttag    /* task startup parameter */
{
  TLR_UINT32    ulTaskIdentifier;
  TLR_UINT32    ulParamVersion;
  
  /** DPM Channel Number for HIF */
  TLR_UINT32  ulDPMChannel;
  /** maximum number of configured IO-Devices */
  TLR_UINT32  ulMaxIODevCnt;

  /** Profinet VendorId to be used in case of database configuration */
  /* in case of packet configuration the value from the packet is used */
  TLR_UINT16  usVendorId;
  /** Profinet DeviceId to be used in case of database configuration */
  /* in case of packet configuration the value from the packet is used */
  TLR_UINT16  usDeviceId;
  /** task flags */
  TLR_UINT32  ulFlags;
};

/** @} */


/*************************************************************************************/
#endif /* #ifndef __PNIO_APCFG_FUNCTIONLIST_H */
